#pragma rtGlobals=1		// Use modern global access method.

Menu "Plot&Fit"
		"Calorimitry Panel",CalorimitryPnl()
End


Function CalorimitryPnl()
	IN2G_CheckScreenSize("height",670)
	DoWindow KJC_CalorimitryPnl
	if(V_Flag)
		DoWindow/K KJC_CalorimitryPnl
	endif
	IR1D_InitDataManipulation()
	IR1P_InitializeGenGraph()
	If(!datafolderexists (" root:Packages:CalorimitryTool"))
		Newdatafolder root:Packages:CalorimitryTool
	endif	
	variable/g root:Packages:CalorimitryTool:GraphLogY=1,root:Packages:CalorimitryTool:GraphLogx=1
	variable/g root:Packages:CalorimitryTool:ALVtheta
	variable/g root:Packages:CalorimitryTool:ALVT
	variable/g root:Packages:CalorimitryTool:ALVD=0
	variable/g root:Packages:CalorimitryTool:ALVRh
	variable/g  root:Packages:CalorimitryTool:ALVOrder=2
	variable/g root:Packages:CalorimitryTool:ALVgamma
	variable/g root:Packages:CalorimitryTool:ALVerrors
	variable/g root:Packages:CalorimitryTool:ALVLambda
	variable/g root:Packages:CalorimitryTool:ALVviscosity
	variable/g root:Packages:CalorimitryTool:ALVn
	variable/g root:Packages:CalorimitryTool:ALVwidth=0
	 variable/g root:Packages:CalorimitryTool:ALVskewness=0
	variable/g root:Packages:CalorimitryTool: ALVCursorA=0
	variable/g root:Packages:CalorimitryTool: ALVCursorB=0
	variable/g root:Packages:CalorimitryTool: ALVorder=3
	variable/g root:Packages:CalorimitryTool: ALVqvector
	variable/g root:Packages:CalorimitryTool:USEqrsData=1
	variable/g root:Packages:CalorimitryTool:ALVLevels=2
	variable/g root:Packages:CalorimitryTool:g1=0
	string/g root:Packages:CalorimitryTool:summarypath
	variable/g root:Packages:CalorimitryTool:SaveTable
	make/o/N=2 xavedata,yavedata
	xavedata={ .02, .15}
	yavedata={ 1, .01}
	PlotCalorimitry("yavedata","xavedata", "")
	setAxis bottom .02, .1
	SetAxis/A left
	removefromgraph yavedata
	textBox/K/N=text0
end

Function PlotCalorimitry(rwavename,qwavename, text)
	string rwavename,qwavename, text
	wave rwave=$rwavename
	wave qwave=$qwavename			
	dowindow/K CalorimitryTool
	Display/K=1/N=CalorimitryTool/W=(1*IN2G_ScreenWidthHeight("width"),1*IN2G_ScreenWidthHeight("heigth"),30*IN2G_ScreenWidthHeight("width"),60*IN2G_ScreenWidthHeight("height")) rwave vs qwave
	ControlBar /T 210
	TitleBox  title anchor= MT,  fColor=(0,0,65534 ), font="arial", fsize=18, fstyle=0, Title="ALV Tool",Labelback=0, POS={225,1},Size={200,18}
	variable YPOS=3
	CheckBox errors pos={70,YPOS},title="Errors?", variable= root:Packages:CalorimitryTool:ALVerrors
	CheckBox GraphLogx pos={135,YPOS},title="LogX", variable= root:Packages:CalorimitryTool:GraphLogx, proc=DWS_GenPlotCheckBox
	CheckBox GraphLogY pos={180,YPOS},title="LogY", variable= root:Packages:CalorimitryTool:GraphLogY, proc=DWS_GenPlotCheckBox
	//CheckBox g1 pos={225,YPOS},title="g1?", variable= root:Packages:CalorimitryTool:g1
	
	YPOS=130
	Button PlotALVData,pos={0,YPOS},size={40,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Plot"		
	Button ClipALV,pos={42,YPOS},size={40,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Clip"		
	Button Restore,pos={83,YPOS},size={45,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Restore"	
	Button RemoveALVTrace,pos={128,YPOS},size={50,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Remove"		
	
	Button LoadASC,pos={219,YPOS},size={35,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Load"		
	Button Restart,pos={255,YPOS},size={45,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Restart"	
	SetVariable ALVorder, pos={310,YPOS}, size={55,20},title="ord", value= root:Packages:CalorimitryTool:ALVorder,limits={2,5,1 },proc= ALV_SetVarProc
	YPOS=150
	SetVariable ALVT, pos={2,YPOS}, size={65,20},title="T",format="%.0f K",value= root:Packages:CalorimitryTool:ALVT
	SetVariable ALVn, pos={70,YPOS}, size={59,20},title="n", value= root:Packages:CalorimitryTool:ALVn		
	SetVariable ALVviscosity, pos={130,YPOS}, size={75,20},title="Vis", format="%.2f cp",limits={0,Inf,0.01},value= root:Packages:CalorimitryTool:ALVviscosity,format= "%.3f"
	SetVariable ALVLambda, pos={210,YPOS}, size={75,20}, title="L",value= root:Packages:CalorimitryTool:ALVLambda	,format="%.1f nm"
	SetVariable ALVtheta, value= root:Packages:CalorimitryTool:ALVtheta	,format="%.1f", pos={295,YPOS}, size={60,20},font="Symbol",fSize=12,title="q"
	YPOS=168
	valdisplay ALVDiff, pos={2,YPOS}, size={100,20},title="D",  value= #"root:Packages:CalorimitryTool:ALVD",format="%.2f m^2/sec"//"%.3g" 
	valdisplay ALVR, pos={100,YPOS}, size={60,20},title="R"	,format="%.1f nm", value=#" root:Packages:CalorimitryTool:ALVRh"
	valdisplay ALVgamma, pos={162,YPOS}, size={85,20},fSize=10,title="Gam",format="%.2f 1/ms", value= #"root:Packages:CalorimitryTool:ALVgamma"
	valdisplay ALVwidth, pos={255,YPOS}, size={50,20},font="Symbol",fSize=10,title="dG/G",format="%.2f", value= #"root:Packages:CalorimitryTool:ALVwidth"
	valdisplay ALVskewness, pos={310,YPOS}, size={65,20},title="skew",format="%.2f", value= #"root:Packages:CalorimitryTool:ALVskewness"
	YPOS=188
	Button ALVsave,pos={3,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Save Results"		
	Button ALVTable,pos={70,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=ALVButtonProc,title="Summary"	
	SetVariable ALVLevels, pos={140,YPOS}, size={60,20},title="Levels", value= root:Packages:CalorimitryTool:ALVLevels,limits={2,5,1 }
	CheckBox SaveTable pos={210,YPOS},title="Save Table?", variable= root:Packages:CalorimitryTool:SaveTable

	String PckgDataFolder="CalorimitryTool"
	String PanelWindowName="CalorimitryTool"
	String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
	String AllowedResultsTypes=""//"SizesNumberDistribution;SizesVolumeDistribution;"
	String AllowedUserTypes=""//"*_par;" or "r*;"	
	String UserNameString=""//"_par" or "qrs"
	String XUserTypeLookup=""//"r*:q*;"	
	String EUserTypeLookup=""//"s*;"
	variable RequireErrorWaves=0
	variable  AllowModelData=0	
	IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,AllowModelData)	
	MoveSelectionTools(2, 2)
end